package org.msh.tb.indicators;

import org.msh.tb.entities.enums.MessageKey;

/**
 * DTO type used to wrap enums when a list (filter in example) has to
 * contain other options than the enum, like "undefined".
 * @param <E>
 */
public class EnumFilterOption<E extends MessageKey> {

    private E value;
    private boolean undefined;

    public EnumFilterOption() { }

    public EnumFilterOption(E value) {
        this.value = value;
        this.undefined = false;
    }

    public E getValue() {
        return value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    public boolean isUndefined() {
        return undefined;
    }

    public void setUndefined(boolean undefined) {
        this.undefined = undefined;
    }

    public String getKey() {
        if (value != null) {
            return value.getMessageKey();
        }

        return "global.notdef";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EnumFilterOption)) {
            return false;
        }

        EnumFilterOption efo = (EnumFilterOption) obj;

        return efo.getKey().equals(this.getKey());
    }

    @Override
    public String toString() {
        if (isUndefined()) return "undefined";

        return value != null ? value.toString() : null;
    }
}
